
Type TLineBrush

	Field _thickness:Float
	Field _color:TColor
	Field _layer:Float
	Field _texture:TImage
	Field _xVector:Vector2 = Vector2.Create(1, 0)
	Field _origin:Vector2 = Vector2.Zero()
	Field _scale:Vector2 = Vector2.Zero()
	Field _rotation:Float
	
	Method GetColor:TColor()
		Return _color
	End Method
	
	Method SetColor(value:TColor) 
		_color = value
	End Method
	
	Method GetThickness:Float() 
		Return _thickness
	End Method
	
	Method SetThickness(value:Float) 
		_thickness = value
	End Method
	
	Method GetLayer:Float() 
		Return _layer
	End Method
	
	Method SetLayer(value:Float) 
		_layer = value
	End Method
	
	
	Function Create:TLineBrush(thickness:Float, color:TColor) 
		Local brush:TLineBrush = New TLineBrush
		brush._thickness = thickness
		brush._color = color.Copy()
		brush._texture = TDrawingHelper.CreateLineTexture(thickness, color)
		Return brush
	End Function
	
	Field _difference:Vector2 = Vector2.Zero()
	Method Draw(startPoint:Vector2, endPoint:Vector2)
		Vector2.SubtractVectorsRef(endPoint, startPoint, _difference)
		CalculateRotation(_difference)
		CalculateScale(_difference)
		SetRotation(_rotation)
		SetScale(_scale.X, _scale.Y)
		DrawImage(_texture, startPoint.X, startPOint.Y)
		SetRotation(0)
		SetScale(1, 1)
	End Method
	
	Field _normalizedDiff:Vector2 = Vector2.Zero()
	Field _theta:Float = 0
	Method CalculateRotation(difference:Vector2)
		Vector2.NormalizeRef(difference, _normalizedDiff)
		_theta = Vector2.Dot(_xVector, _normalizedDiff)
		
		_theta = ACos(_theta)
		If _difference.Y < 0 Then _theta = -_theta
		_rotation = _theta
	End Method
	
	Method CalculateScale(difference:Vector2)
		Local desiredLength:Float = difference.Length()
		_scale.X = desiredLength / _texture.width
		_scale.Y = 1
	End Method
End Type
